

	/**
	 * ATTENTION : les variables vg_* doivent �tre initialis�es avec les donn�es de la grande galerie
	 */
	var vg_max			= 3;
	// N� associ� � la premi�re vignette affich�e
	var vg_encours		= 1;
	var vg_prefixe		= 'gp';
	var vg_mode			= 'photo';
	var vg_mode_exec	= false;
// g�r� dans les fichiers js_tablet.js, js_mobile.js et js_monitor.js
//	var vg_ratio	= 'monitor';

/*
	function gotoBottom(id){
		   var element = document.getElementById(id);
		   element.scrollTop = element.scrollHeight - element.clientHeight;
		}
*/
	// ================================================================================================
	function init_affichage()
	{
		afficher();
	}
	// ================================================================================================
	/**
	 * Affiche la galerie en cours (relative � vg_prefixe ) et active si n�cessaire les boutons permettant de faire Prev/Next
	 */
	function afficher()
	{
		document.getElementById(vg_prefixe+"_titre").className  = "etat_visible";

		// ========== Affichage vignette 1
		document.getElementById(vg_prefixe+"_"+vg_encours).className		= "gal_case gal_pos1";
		// ========== Affichage vignette 2
		if	(vg_encours+1 <= vg_max && vg_max_aff >= 2)
		{	document.getElementById(vg_prefixe+"_"+(vg_encours+1)).className	= "gal_case gal_pos2";
		}
		// ========== Affichage vignette 3
		if	(vg_encours+2 <= vg_max && vg_max_aff >= 3)
		{	document.getElementById(vg_prefixe+"_"+(vg_encours+2)).className	= "gal_case gal_pos3";
		}


		// ========== AFFICHAGE DU BOUTON PREV
		if	(vg_encours > 1)
		{	document.getElementById("bt_prev").className		= "bt bt_prev etat_visible";
		}
		else
		{	document.getElementById("bt_prev").className		= "bt bt_prev etat_invisible";
		}


		// ========== AFFICHAGE DU BOUTON NEXT
		if	(vg_encours+vg_max_aff-1 < vg_max)
		{	document.getElementById("bt_next").className		= "bt bt_next etat_visible";
		}
		else
		{	document.getElementById("bt_next").className		= "bt bt_next etat_invisible";
		}

	}
	// ================================================================================================
	/**
	 * Efface la galerie en cours (relative � vg_prefixe )
	 */
	function effacer(pBooTitre)
	{
		if	(pBooTitre== undefined)
		{	pBooTitre = true;
		}

		if	(pBooTitre)
		{	document.getElementById(vg_prefixe+"_titre").className  			= "etat_invisible";
		}

		document.getElementById("bt_prev").className							= "bt bt_prev etat_invisible";
		document.getElementById("bt_next").className							= "bt bt_next etat_invisible";

		// ========== Effacer vignette 1
		document.getElementById(vg_prefixe+"_"+vg_encours).className			= "gal_case etat_invisible";
		// ========== Effacer vignette 2
		if	(vg_encours+1 <= vg_max && vg_max_aff >= 2)
		{	document.getElementById(vg_prefixe+"_"+(vg_encours+1)).className	= "gal_case etat_invisible";
		}
		// ========== Effacer vignette 3
		if	(vg_encours+2 <= vg_max && vg_max_aff >= 3)
		{	document.getElementById(vg_prefixe+"_"+(vg_encours+2)).className	= "gal_case etat_invisible";
		}
	}
	// ================================================================================================
	/**
	 * Change la galerie qui doit �tre affich�e
	 * 
	 * @param vp_prefixe	string	Pr�fixe de la galerie � afficher (gp, pp, nm, la) 
	 */
	function initier(vp_prefixe)
	{
		effacer();

		vg_prefixe	= vp_prefixe;
		vg_encours	= 1;

		switch (vg_prefixe)
		{
			case "gp" : vg_max = 3;
						break;
			case "pp" : vg_max = 4;
						break;
			case "nm" : vg_max = 4;
						break;
			case "la" : vg_max = 1;
						break;
			default :
		}
		afficher();
	}
	// ================================================================================================
	/**
	 * Passe � l'image suivante de la galerie par d�placement horizontal vers la gauche
	 */
	function f_next()
	{
		effacer(false);
		vg_encours += 1;
		afficher(vg_prefixe);
	}
	// ================================================================================================
	/**
	 * Passe � l'image pr�c�dente de la galerie par d�placement horizontal vers la droite
	 */
	function f_prev()
	{
		effacer(false);
		vg_encours -= 1;
		afficher(vg_prefixe);
	}
	// ================================================================================================
	function ouvrirGalerieV2(pGalerie)
	{
		var vlSuppl		= 15;
		var vlPaint		= false;
		var vlRatio		= '';
		var vlMessage	= '';
		var vlOptions	= '';
		var vlOptionsFF	= '';
		var vlWidth		= 0;
		var vlHeight	= 0;
		
		switch (pGalerie)
		{
			case 'payre' :
				vlPaint = true;
			case 'megalithes' :
				vlPaint = true;
			case 'art' :
				// monitor : w:900, h:900 
				// tablet  : w:580, h:580
				// mobile  : w:310
				// Peinture : non 
				if (vg_ratio == 'monitor')
				{	vlRatio		= 'monitor';
					vlWidth		= 900 + vlSuppl;
					vlHeight	= 900 + vlSuppl;
				}
				else if (vg_ratio == 'tablet')
				{	vlRatio = 'tablet';
					vlWidth		= 580 + vlSuppl;
					vlHeight	= 580 + vlSuppl;
				}
				else
				{	vlRatio = 'mobile';
				}
				break;
			case 'chateaux' :
				// monitor : w:1250, h:830 
				// tablet  : w:880, h:584
				// mobile  : w:310
				// Peinture : oui 
				vlPaint = true;
				if (vg_ratio == 'monitor')
				{	vlRatio		= 'monitor';
					vlWidth		= 1260+10;	// Attention = 1270, au lieu de 1260 au 01/04/2019 car les bandes de défilement apparaissent
					vlHeight	= 840+10;	// Attention = 850, au lieu de 840 au 01/04/2019 car les bandes de défilement apparaissent 
				}
				else if (vg_ratio == 'tablet')
				{	vlRatio = 'tablet';
					vlWidth		= 880+10;
					vlHeight	= 584+10;
				}
				else
				{	vlRatio = 'mobile';
				}
				break;
			case 'gaelle' :
				// monitor : w:1100, h:590 
				// 	tablet  : w:978, h:525
				// 	mobile  : w:...
				// Peinture : non 
				if (vg_ratio == 'monitor')
				{	vlRatio		= 'monitor';
					vlWidth		= 1110+10;
					vlHeight	= 600+10;
				}
				else if (vg_ratio == 'tablet')
				{	vlRatio = 'tablet';
					vlWidth		= 978+10;
					vlHeight	= 525+10;
				}
				else
				{	vlMessage = 'Votre �cran n\'a pas une r�solution suffisante pour afficher cette galerie.';
				}
				break;
			case 'noviciat_mers_2002' :
				// monitor : w:1264, h:768 
				// tablet  : w:970, h:589
				// mobile  : w:310
				// Peinture : non 
				vlPaint = true;
				if (vg_ratio == 'monitor')
				{	vlRatio		= 'monitor';
					vlWidth		= 1274+10;
					vlHeight	= 778+10;
				}
				else if (vg_ratio == 'tablet')
				{	vlRatio = 'tablet';
					vlWidth		= 970+10;
					vlHeight	= 589+10;
				}
				else
				{	vlRatio = 'mobile';
				}
				break;
			case 'noviciat_mers_2003' :
				// monitor : w:1264, h:768 
				// tablet  : w:970, h:589
				// mobile  : w:310
				// Peinture : non 
				vlPaint = true;
				if (vg_ratio == 'monitor')
				{	vlRatio		= 'monitor';
					// aligner css_monitor.#main
					// +10 pour border et + 10 de réserve
					vlWidth		= 1275+15;
					vlHeight	= 830+15;
				}
//TODO : revoir les ratio tablet par rapport au ratio monitor
				else if (vg_ratio == 'tablet')
				{	vlRatio = 'tablet';
					vlWidth		= 970+10;
					vlHeight	= 589+10;
				}
				else
				{	vlRatio = 'mobile';
				}
				break;
			case 'noviciat_mers_2005' :
				// monitor : w:1024, h:768 
				// tablet  : w:1024, h:768
				// mobile  : NON
				// Peinture : oui
//				vlPaint = true;
				if (vg_ratio == 'monitor')
				{	vlRatio		= 'monitor';
					vlWidth		= 1024+10;
					vlHeight	= 768+10;
				}
				else if (vg_ratio == 'tablet')
				{	// ATTENTION : RUSE : on reste en format monitor, m�me pour une tablette
					//vlRatio = 'tablet';
					vlRatio = 'monitor';
					vlWidth		= 1024+10;
					vlHeight	= 768+10;
				}
				else
				{	vlMessage = 'Votre écran n\'a pas une résolution suffisante pour accéder au jeu.';
				}
				break;
		}
		// probl�me bug OpenWindow Safari qui laisse une marge 
		if (navigator.appVersion.indexOf('Safari') > 0 && vlRatio != 'mobile')
		{	vlHeight -= 50;
		}

		if	(vlMessage != '')
		{
			alert(vlMessage);
		}
		else
		{
			vlOptions	= 'menubar=no,toolbar=no,location=no,resizable=no,status=no,statusbar=no,scroobars=no';
			vlOPtionsFF = ',directories=no,personalbar=no,addressbar=no';
			vlOptions	+= ',width='+vlWidth+',height='+vlHeight;
			//	TODO : mettre en place un switch case pour rajouter les options suivant le type de navigateur
			vlOptions	+= vlOPtionsFF; 

			if	(vlRatio == 'mobile')
			{	vlOptions='';
			}
//alert('../'+pGalerie+'/'+'index_'+(vlPaint && vg_mode=="paint" ? 'paint':'photo')+'_'+vlRatio+'.php?s=page&n=1'+'  OPtions='+vlOptions);
			VarImp=window.open('../'+pGalerie+'/'+'index_'+(vlPaint && vg_mode=="paint" ? 'paint':'photo')+'_'+vlRatio+'.php?s=page&n=1',pGalerie,vlOptions);
		}
	}
	// ================================================================================================
	function ouvrirGalerie(pGalerie, pScroll)
	{
		/* Pour 910 * 910
		 * Firefox : 938 * 993
		 * Safari  : 936 * 1040 mais !!! 92px en trop sur Height (1040-92 = 948
		 * I.E.    : 940 * 962
		 */
		var vlRatio		= '';
		var vlWidth		= 0;
		var vlHeight	= 0;
		var vlScroll	= true;
		var vlPaint		= false;
		var vlOptions	= '';
		var vlOptionsFF	= '';
		var vlMessage	= '';
		var top_w		= 0;
		var top_h		= 0;

		var vlScreenH	= screen.height;
		var vlScreenW	= screen.width;

		switch (pGalerie)
		{
			/*
			 *  ATTENTION : width et height doivent intégrer la bordure de 2*5px
			 */
			case 'gaelle' :
				// monitor : w:1100, h:590 
				// 	tablet  : w:978, h:525
				// 	mobile  : w:...
				// Peinture : non 
				if	(vg_ratio == 'mobile')
				{	vlMessage = 'Votre écran n\'a pas une résolution suffisante pour afficher cette galerie.';
				}
				else if ((vlScreenH > 590+10) & (vlScreenW > 1100+10) && (vg_ratio == '' || vg_ratio == 'monitor'))
				{	vlRatio		= 'monitor';
					vlScroll	= false;
					vlWidth		= 1100+10;
					vlHeight	= 590+10;
				}
				
				else if (((vlScreenH > 525+10) & (vlScreenW > 978+10)) || vg_ratio == 'tablet')
				{	vlRatio = 'tablet';
					vlScroll	= false;
					vlWidth		= 978+10;
					vlHeight	= 525+10;
				}
				else
				{	vlMessage = 'Votre écran n\'a pas une résolution suffisante pour afficher cette galerie.';
				}
				break;
			case 'chateaux' :
				// monitor : w:1250, h:830 
				// tablet  : w:880, h:584
				// mobile  : w:310
				// Peinture : oui 
				vlPaint = true;
				if	(vg_ratio == 'mobile')
				{	vlRatio = 'mobile';
				}
				else if ((vlScreenH > 880+10) & (vlScreenW > 1250+10) && (vg_ratio == '' || vg_ratio == 'monitor'))
				{	vlRatio		= 'monitor';
					vlScroll	= false;
					vlWidth		= 1250+10;	// Attention = 1260
					vlHeight	= 830+10;	// Attention = 840 
				}
				else if (((vlScreenH > 584+10) & (vlScreenW > 880+10)) || vg_ratio == 'tablet')
				{	vlRatio = 'tablet';
					vlScroll	= false;
					vlWidth		= 880+10;
					vlHeight	= 584+10;
				}
				else
				{	vlRatio = 'mobile';
				}
				break;
			case 'noviciat_mers_2002' :
				// monitor : w:1264, h:768 
				// tablet  : w:970, h:589
				// mobile  : w:310
				// Peinture : non 
				vlPaint = true;
				if	(vg_ratio == 'mobile')
				{	vlRatio = 'mobile';
				}
				else if ((vlScreenH > 768+10) & (vlScreenW > 1264+10) && (vg_ratio == '' || vg_ratio == 'monitor'))
				{	vlRatio		= 'monitor';
					vlScroll	= false;
					vlWidth		= 1264+10;
					vlHeight	= 768+10;
				}
				else if (((vlScreenH > 589+10) & (vlScreenW > 970+10)) || vg_ratio == 'tablet')
				{	vlRatio = 'tablet';
					vlScroll	= false;
					vlWidth		= 970+10;
					vlHeight	= 589+10;
				}
				else
				{	vlRatio = 'mobile';
				}
				break;
			case 'noviciat_mers_2005' :
				// monitor : w:1024, h:768 
				// tablet  : w:1024, h:768
				// mobile  : NON
				// Peinture : oui
				vlPaint = true;
				if	(vg_ratio == 'mobile')
				{	vlMessage = 'Votre écran n\'a pas une résolution suffisante pour accéder au jeu.';
				}
				else if ((vlScreenH > 768+10) & (vlScreenW > 1024+10) && (vg_ratio == '' || vg_ratio == 'monitor'))
				{	vlRatio		= 'monitor';
					vlScroll	= false;
					vlWidth		= 1024+10;
					vlHeight	= 768+10;
				}
				else if (((vlScreenH > 768+10) & (vlScreenW > 1024+10)) || vg_ratio == 'tablet')
				{	// ATTENTION : RUSE : on reste en format monitor, même pour une tablette
					//vlRatio = 'tablet';
					vlRatio = 'monitor';
					vlScroll	= false;
					vlWidth		= 1024+10;
					vlHeight	= 768+10;
				}
				else
				{	vlMessage = 'Votre écran n\'a pas une résolution suffisante pour accéder au jeu.';
				}
				break;
			case 'payre' :
				vlPaint = true;
			case 'art' :
					// monitor : w:900, h:900 
					// tablet  : w:580, h:580
					// mobile  : w:310
					// Peinture : non 
					if	(vg_ratio == 'mobile')
					{	vlRatio = 'mobile';
					}
					else if ((vlScreenH > 900+10) & (vlScreenW > 900+10) && (vg_ratio == '' || vg_ratio == 'monitor'))
					{	vlRatio		= 'monitor';
						vlScroll	= false;
						vlWidth		= 900+10;
						vlHeight	= 900+10;
					}
					else if (((vlScreenH > 580+10) & (vlScreenW > 580+10)) || vg_ratio == 'tablet')
					{	vlRatio = 'tablet';
						vlScroll	= false;
						vlWidth		= 580+10;
						vlHeight	= 580+10;
					}
					else
					{	vlRatio = 'mobile';
					}
				break;
			case 'megalithes' :
				// monitor : w:900, h:900 
				// tablet  : w:580, h:580
				// mobile  : w:310
				// Peinture : oui
				vlPaint = true;
				if	(vg_ratio == 'mobile')
				{	vlRatio = 'mobile';
				}
				else if ((vlScreenH > 900+10) & (vlScreenW > 900+10) && (vg_ratio == '' || vg_ratio == 'monitor'))
				{	vlRatio		= 'monitor';
					vlScroll	= false;
					vlWidth		= 910+10;
					vlHeight	= 910+10;
				}
				else if (((vlScreenH > 580+10) & (vlScreenW > 580+10)) || vg_ratio == 'tablet')
				{	vlRatio = 'tablet';
					vlScroll	= false;
					vlWidth		= 580+10;
					vlHeight	= 580+10;
				}
				else
				{	vlRatio = 'mobile';
				}
				break;
			default:
		}

//alert("vg_ratio=["+vg_ratio+"], vl_ratio=["+vlRatio+"], vlScreeH=["+vlScreenH+"], vlScreenW=["+vlScreenW+"]");

		// problème bug OpenWindow Safari qui laisse une marge 
		if (navigator.appVersion.indexOf('Safari') > 0 && vlRatio != 'mobile')
		{	vlHeight -= 50;
		}

		if	(vlHeight > 0 && vlScreenH > vlHeight)
		{	top_h = parseInt((vlScreenH-30 - (vlHeight+30)) / 2);
		}
		if	(vlWidth > 0 && vlScreenW > vlWidth)
		{	top_w = parseInt((vlScreenW-30 - (vlWidth+30)) / 2);
		}
//alert(vlMessage);
		if	(vlMessage != '')
		{
			alert(vlMessage);
		}
		else
		{

			vlOptions	= 'menubar=no,toolbar=no,location=no,resizable=no,status=no,statusbar=no,scroobars='+(pScroll=true?'yes':'no');
			vlOPtionsFF = ',directories=no,personalbar=no,addressbar=no';
			vlOptions	+= ',top='+top_h+',left='+top_w+',width='+vlWidth+',height='+vlHeight;
			//	TODO : mettre en place un switch case pour rajouter les options suivant le type de navigateur
			vlOptions	+= vlOPtionsFF; 

			if	(vlRatio == 'mobile')
			{	vlOptions='';
			}

//alert(vlOptions);
			VarImp=window.open('../'+pGalerie+'/'+'index_'+(vlPaint && vg_mode=="paint" ? 'paint':'photo')+'_'+vlRatio+'.php?s=page&n=1',pGalerie,vlOptions);
		}

	}
	// ================================================================================================
	/**
	 * Vérifie les dimensions de l'écran puis ouvre la fenêtre qui doit accueillir la série à afficher
	 * 
	 * @param pWidth		int		Width nécessaire
	 * @param pHeight		int		Height nécessaire
	 * @param par_dir		string	Répertoire de la série
	 * @param pScroll		string	Indique si le scroll est autorisé (yes/no)
	 * @param par_nom		string	Nom donné à l'instance de fenêtre pour pouvoir ouvrir plusieurs fenêtres différentes
	 * @param par_peinture	boolean	True si le site peut aussi être visualisé en peinture, sinon False	
	 */
	function openWindow(pWidth, pHeight,par_dir,pScroll,par_nom, par_peinture)
	{
		var top_w    	= 0;
		var top_h    	= 0;
		var vlOptions	= "";

		// ========== CONTROLE RESOLUTION ECRAN PAR RAPPORT A LA GALERIE A AFFICHER
		if ((pHeight > screen.height) || (pWidth > screen.width))
		{	alert("ATTENTION, votre résolution écran n'est pas suffisante pour afficher cette galerie.");
			return;
		}

		// problème bug OpenWindow Safari qui laisse une marge 
		if (navigator.appVersion.indexOf('Safari') > 0)
		{	pHeight -= 45;
		}

		if (screen.height > pHeight)
		{	top_h = parseInt((screen.height-30 - (pHeight+30)) / 2);
		}
		if (screen.width > pWidth)
		{	top_w = parseInt((screen.width - (pWidth+10)) / 2);
		}

		vlOptions	= 'menubar=no,toolbar=no,location=no,resizable=no,status=no,scroobars='+(pScroll=true?'yes':'no');
		vlOPtionsFF = ',directories=no,personalbar=no';
		vlOptions	+= ',top='+top_h+',left='+top_w+',width='+pWidth+',height='+pHeight;
		//TODO : mettre en place un switch case pour rajouter les options suivant le type de navigateur
		vlOptions	+= vlOPtionsFF; 

//		VarImp=window.open('../'+pGalerie+'/'+'index_'+(vlPaint && vg_mode=="paint" ? 'paint':'photo')+'_'+vlRatio+'.php?s=page&n=1',pGalerie,vlOptions);

//		VarImp=window.open(par_dir+'/'+(par_peinture && document.forms[0].choice[1].checked?'mode_peinture':'mode_photo')+'/'+'page_01.php',par_nom,"top="+top_h+",left="+top_w+",width="+pWidth+",height="+pHeight+",scrollbars="+par_scroll);
		VarImp=window.open('../'+(par_peinture && vg_mode=="paint" ? 'version_peinture':'version_photo')+'/'+par_dir+'/'+'index.htm',par_nom,vlOptions);
	}
